// CheckerConsole.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
//#include <assert.h>
//#include <windows.h>
#include <windows.h>
#include <stdio.h>

// board values
#define EMPTY    0		// un_occupied dark square
#define WHITE    1
#define BLACK    2
#define MAN      4
#define KING     8
#define FREE    16		// the light squares, always _free
#define CC       3		// change colour


// getmove return values
#define DRAW    0
#define WIN     1
#define LOSS    2
#define UNKNOWN 3


// ENGLISH
/*const int en[8][8] = {
	{4, 0, 3, 0, 2, 0, 1, 0},
	{0, 8, 0, 7, 0, 6, 0, 5},
	{12, 0, 11, 0, 10, 0, 9, 0},
	{0, 16, 0, 15, 0, 14, 0, 13},
	{20, 0, 19, 0, 18, 0, 17, 0},
	{0, 24, 0, 23, 0, 22, 0, 21},
	{28, 0, 27, 0, 26, 0, 25, 0},
	{0, 32, 0, 31, 0, 30, 0, 29},
};
*/
// types
typedef struct
{
  int x;			// file
  int y;			// row
}
coor;

typedef struct
{
  int jumps;			// how many jumps are there in this move?
  int newpiece;			// what type of piece appears on to
  int oldpiece;			// what disappears on from
  coor from, to;		// coordinates of the squares in 8x8 notation!
  coor path[12];		// intermediate path coordinates
  coor del[12];			// squares whose pieces are deleted
  int delpiece[12];		// what is on these squares
}
CBmove;

typedef int (* tCommand) (char *, char *);
typedef int (* tIsLegal) (int[8][8], int, int, int, CBmove *);
typedef int (__stdcall * tGetMove) (int[8][8], int, double, char *, int *, int, int, CBmove *);

tCommand eCommand;
tIsLegal eIsLegal;
tGetMove eGetMove;

HINSTANCE handle;

static int loadlib (/*gameinfo * gi, CBengine * engine*/)
{
	char enginepath[512] = "dama.dll";

	handle = LoadLibrary (enginepath);

	if (!handle)
	{
		printf ("DLL not found: %s.\n", enginepath);
		return 0;
	}
	eCommand = (tCommand) GetProcAddress (handle, "enginecommand");
	eIsLegal = (tIsLegal) GetProcAddress (handle, "islegal");
	eGetMove = (tGetMove) GetProcAddress (handle, "getmove");
}

// initialize an 8x8 board to the starting position
static void initboard (int b[8][8])
{
	int x, y, r;			// row, column, rotation

	r = 0;

	for (y = 0; y < 8; y++)
		for (x = 0; x < 8; x++)
			if ((x + y) % 2 == r)
				b[x][y] = EMPTY;
			else
				b[x][y] = FREE;

	b[0][0] = b[2][0] = b[4][0] = b[6][0] =
		b[1][1] = b[3][1] = b[5][1] = b[7][1] =
		b[0][2] = b[2][2] = b[4][2] = b[6][2] = BLACK | MAN;
    b[1][7] = b[3][7] = b[5][7] = b[7][7] =
		b[0][6] = b[2][6] = b[4][6] = b[6][6] =
		b[1][5] = b[3][5] = b[5][5] = b[7][5] = WHITE | MAN;
}

static void initboard(int b[8][8], char *s[])
{
	for (int i = 0; i< 8; i++)
	{
		for (int j = 0; j< 8; j++)
		{
			b[7-j][i] = atoi(s[i*8+j+2]);
		}
	}
}

// parameters:
// w/b f(B/W+M/K)... 
/*
initialboard = [
    6 16 6 16 6 16 6 16;
    16 6 16 6 16 6 16 6;
    6 16 6 16 6 16 6 16;
    16 0 16 0 16 0 16 0;
    0 16 0 16 0 16 0 16;
    16 5 16 5 16 5 16 5;
    5 16 5 16 5 16 5 16;
    16 5 16 5 16 5 16 5];
*/
int _tmain(int argc, _TCHAR* argv[])
{
	if (argc != 66)
	{
		printf ("\n wrong parametrization \n");
		return -1;
	}

	loadlib();
	
	// who's next?
	int color = atoi(argv[1]);
	//printf ("\n%d\n", color);
	// current board state:
	int board[8][8];
	initboard(board, argv);

	// other parameters
	//char command[64] = ""; not used
	//char reply[1024] = ""; not used
	CBmove cbmove;
	
	double maxtime = 0.5;
	char str[1024];
	int playnow = 0, info = 0, moreinfo = 0;

	int value = eGetMove(board, color, maxtime, str, &playnow, info, moreinfo, &cbmove);
	
	//returning the result (flipping)
	printf ("%d %d\n%d %d\n", 7-cbmove.from.x, cbmove.from.y, 7-cbmove.to.x, cbmove.to.y);
	printf ("\n%s\n", str);
	
	//value = eIsLegal(board, color, from, to, &cbmove);


	//getchar();

	return 0;
}

